package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.bluebutton.model.Study;
import gov.va.med.mhv.bluebutton.transfer.StudyDTO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class StudyConverter implements Converter<Study, StudyDTO> {
	@Autowired
	FacilityInfoConverter facilityInfoConverter;
	
	@Override
	public StudyDTO convert(Study source) {
		StudyDTO d = new StudyDTO();
		d.setId(source.getId());
		d.setEvent(source.getEvent());
		d.setFacilityInfo(facilityInfoConverter.convert(source.getFacilityInfo()));
		d.setImageCount(source.getImageCount());
		d.setPatientId(source.getPatientId());
		d.setPerformedDateImprecise(source.getPerformedDate().getDateImprecise());
		d.setPerformedDatePrecise(source.getPerformedDate().getDatePrecise());
		d.setProcedureName(source.getProcedureName());
		d.setStationNumber(source.getStationNumber());
		d.setStudyIdUrn(source.getStudyIdUrn());
		d.setReportText(source.getReportText());
		return d;
	}
}
